

<?php $__env->startSection('content'); ?>

<div class="card">
	<div class="d-sm-flex align-items-center justify-content-between">
	<h5 class=" mb-0 text-gray-800 pl-3"><?php echo e(__('Referral System')); ?></h5>
	<ol class="breadcrumb">
		<li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>

		<li class="breadcrumb-item"><a href="<?php echo e(route('admin.referral.index')); ?>"><?php echo e(__('Referral System')); ?></a></li>
	</ol>
	</div>
</div>


<!-- Row -->
<div class="row mt-3">
  <div class="col-lg-7">
	<div class="card mb-4">
        <div class="table-responsive p-3">
            <table id="geniustable" class="table table-hover dt-responsive" cellspacing="0" width="100%">
              <thead class="thead-light">
                <tr>
                    <th><?php echo e(__('Level')); ?></th>
                    <th><?php echo e(__('Bonus')); ?></th>
                </tr>
              </thead>
    
              <tbody>
                  <?php $__empty_1 = true; $__currentLoopData = $referrals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo app('translator')->get('LEVEL'); ?># <?php echo e($data->level); ?></td>
                        <td><?php echo e($data->percent); ?> (%)</td>
                    </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                      <tr>
                          <td><?php echo app('translator')->get('No Data Found'); ?></td>
                      </tr>
                  <?php endif; ?>
              </tbody>
            </table>
          </div>
	</div>
  </div>

  <div class="col-lg-5">
	<div class="card">
        <div class="row pt-5 pb-3 px-3">
            <?php if(\Session::has('success')): ?>
                <div class="alert alert-success">
                    <p>
                        <?php
                        echo \Session::get('success');
                        ?>
                    </p>
                </div>
            <?php endif; ?>
            <div class="col-md-6 col-lg-12 col-xl-6">
                <div class="form-group">
                    <label for="title"><?php echo e(__('Set Number Of Level')); ?></label>
                    <input type="text" class="form-control" id="level" name="level" placeholder="<?php echo e(__('Enter Level')); ?>" value="" required>
                  </div>
            </div>

            <div class="col-md-6 col-lg-12 col-xl-6">
                <label for="title" class="d-none d-md-block d-lg-none d-xl-block">&nbsp;</label>
                <button type="button" id="submit-btn" class="btn btn-primary w-100 generate"><?php echo e(__('Generate')); ?></button>
            </div>
        </div>
        <form action="<?php echo e(route('admin.referral.store')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="featured-keyword-area p-3">
                <div class="lang-tag-top-filds" id="referral-section">

                </div>
                <button type="submit" id="levelFormBtn" class="btn btn-primary w-100 d-none"><?php echo e(__('Submit')); ?></button>
            </div>
        </form>
	</div>
  </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).on('click',".generate",function(){
            let level = $("#level").val();
            levelHtml = '';
            if(parseInt(level)>0){
                $("#levelFormBtn").removeClass('d-none');
                for(let i=1; i<=parseInt(level); i++){
                    levelHtml += `
                        <div class="lang-area">
                            <span class="remove lang-remove"><i class="fas fa-times"></i></span>
                            <div class="row">
                                <div class="col-md-6">
                                    <input type="text" class="form-control" id="level" name="level[]" placeholder="<?php echo app('translator')->get('LEVEL'); ?># ${i}" value="${i}" readonly>
                                </div>
                                <div class="col-md-6">
                                    <input type="number" class="form-control" id="level" name="percent[]" placeholder="<?php echo e(__('Enter Level Percentage')); ?>" value="" required>
                                </div>
                            </div>
                        </div>
                    `;
                }
            }
            $("#referral-section").html(levelHtml);
        })

        $(document).on('click','.lang-remove', function(){
            $(this.parentNode).remove();
            
        })
    </script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\mamp\htdocs\geniushyip\project\resources\views/admin/referral/index.blade.php ENDPATH**/ ?>