

<?php $__env->startPush('css'); ?>
    
<?php $__env->stopPush(); ?>

<?php $__env->startSection('contents'); ?>
<div class="breadcrumb-area">
    <h3 class="title"><?php echo app('translator')->get('Withdraw History'); ?></h3>
    <ul class="breadcrumb">
        <li>
            <a href="<?php echo e(route('user.withdraw.index')); ?>"><?php echo app('translator')->get('Payout'); ?></a>
        </li>
        <li>
            <?php echo app('translator')->get('Withdraw History'); ?>
        </li>
    </ul>
</div>

<div class="dashboard--content-item">
    <div class="card p-3 default--card">
      <form action="<?php echo e(route('user.withdraw.history')); ?>" method="get">
        <div class="row g-3">
          <div class="col-md-4">
            <input name="trx_no" class="form-control" autocomplete="off" placeholder="<?php echo e(__('Transaction no')); ?>" type="text" value="<?php echo e(old('trx_no')); ?>">
          </div>
  
          <div class="col-md-4">
            <select id="type" name="type" required class="form-control">
              <option value=""><?php echo e(__('Select Type')); ?></option>                              
              <option value="all"><?php echo e(__('All')); ?></option>                              
              <option value="pending"><?php echo e(__('Pending')); ?></option>                              
              <option value="completed"><?php echo e(__('Completed')); ?></option>                              
              <option value="rejected"><?php echo e(__('Rejected')); ?></option>                              
            </select>
          </div>
  
          <div class="col-md-4">
            <button type="submit" class="cmn--btn bg--primary submit-btn w-100 border-0"><?php echo e(__('Submit')); ?></button>
          </div>
        </div>
      </form>
    </div>
</div>

<div class="dashboard--content-item">
    <div class="table-responsive table--mobile-lg">
        <table class="table bg--body">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Buyer'); ?></th>
                    <th><?php echo app('translator')->get('Transaction no'); ?></th>
                    <th><?php echo app('translator')->get('Payment Method'); ?></th>
                    <th><?php echo app('translator')->get('Amount'); ?></th>
                    <th><?php echo app('translator')->get('Fee'); ?></th>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <th><?php echo app('translator')->get('Options'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php if(count($withdraws) == 0): ?>
                    <tr>
                        <td colspan="12">
                            <h4 class="text-center m-0 py-2"><?php echo e(__('No Data Found')); ?></h4>
                        </td>
                    </tr>
                <?php else: ?>
                    <?php $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>  
                    <tr>
                        <td data-label="Buyer">
                            <div class="cmn--media">
                                <img src="<?php echo e(auth()->user()->photo ? asset('assets/images/'.auth()->user()->photo) : asset('assets/front/images/clients/client1.jpg')); ?>" alt="clients">
                                <h6 class="m-0 subtitle"><?php echo e(auth()->user()->name); ?></h6>
                            </div>
                        </td>
                        <td data-label="Transaction no">
                            <div>
                                <?php echo e(strtoupper($data->txnid)); ?>

                            </div>
                        </td>

                        <td data-label="Payment Method">
                            <div>
                                <?php echo e(ucfirst($data->method)); ?>

                            </div>
                        </td>

                        <td data-label="Amount">
                            <div>
                                <?php echo e(convertedPrice($data->amount,$data->currency_id)); ?>

                            </div>
                        </td>

                        <td data-label="Fee">
                            <div>
                                <?php echo e(convertedPrice($data->fee,$data->currency_id)); ?>

                            </div>
                        </td>

                        <td data-label="Status">
                            <div>
                                <?php if($data->status == 'pending'): ?>
                                    <span class="badge btn--warning btn-sm"><?php echo app('translator')->get('Pending'); ?></span>
                                <?php elseif($data->status == 'completed'): ?>
                                    <span class="badge btn--success btn-sm"><?php echo app('translator')->get('Completed'); ?></span>
                                <?php else: ?>
                                    <span class="badge btn--danger btn-sm"><?php echo app('translator')->get('Rejected'); ?></span>
                                <?php endif; ?>
                            </div>
                        </td>

                        <td data-label="Options">
                            <div class="text-center">
                                <a href="<?php echo e(route('user.withdraw.details',$data->id)); ?>" class="btn btn--base text--dark btn-sm">
                                    <i class="fas fa-info-circle"></i>
                                    <?php echo app('translator')->get('details'); ?>
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\mamp\htdocs\geniushyip\project\resources\views/user/withdraw/history.blade.php ENDPATH**/ ?>