

<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Banner -->
    <section class="banner-section bg--gradient overflow-hidden position-relative border-bottom">
        <div class="hero-bg bg_img" data-img="<?php echo e(asset('assets/images/'.$gs->breadcumb_banner)); ?>"></div>
        <div class="container">
            <div class="hero-text">
                <h2 class="hero-text-title"><?php echo app('translator')->get('Contact US'); ?></h2>
                <ul class="breadcrumb">
                    <li>
                        <a href="<?php echo e(route('front.index')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                    </li>
                    <li>
                        <?php echo app('translator')->get('Contact US'); ?>
                    </li>
                </ul>
            </div>
        </div>
        </div>
    </section>
    <!-- Banner -->


    <!-- Contact Section -->
    <section class="contact-section overflow-hidden bg--gradient-light pb-100 pt-100 border-bottom">
        <div class="container">
            <div class="row gy-5 flex-wrap-reverse">
                <div class="col-lg-6">
                    <div class="mapouter">
                        <div class="gmap_canvas">
                            <iframe width="600" height="400" id="gmap_canvas"
                                src="https://maps.google.com/maps?q=<?php echo e($gs->latitude); ?>,<?php echo e($gs->longitude); ?>&t=&z=13&ie=UTF8&iwloc=&output=embed"
                                frameborder="0" scrolling="no" marginheight="0" marginwidth="0">
                            </iframe>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="ms-xl-4 ms-xxl-5">
                        <div class="section-header">
                            <h6 class="section-header__subtitle mt-0"><?php echo app('translator')->get('Contact US'); ?></h6>
                            <h2 class="section-header__title"><?php echo e($ps->side_title); ?></h2>
                            <p>
                                <?php echo e($ps->side_text); ?>

                            </p>
                        </div>
                        <div class="contact-area">
                            <div class="contact__item">
                                <div class="contact__item-icon">
                                    <i class="fas fa-map-marker-alt"></i>
                                </div>
                                <div class="contact__item-cont">
                                    <h6 class="contact__item-cont-title"><?php echo app('translator')->get('Headquater'); ?></h6>
                                    <span class="text--base">
                                        <?php echo e($ps->street); ?>

                                    </span>
                                </div>
                            </div>
                            <div class="contact__item">
                                <div class="contact__item-icon">
                                    <i class="fas fa-phone"></i>
                                </div>
                                <div class="contact__item-cont">
                                    <h6 class="contact__item-cont-title"><?php echo app('translator')->get('Call US'); ?></h6>
                                    <a href="<?php echo e($ps->phone); ?>" class="text--base"><?php echo e($ps->phone); ?></a>
                                </div>
                            </div>
                            <div class="contact__item">
                                <div class="contact__item-icon">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <div class="contact__item-cont">
                                    <h6 class="contact__item-cont-title"><?php echo app('translator')->get('Email US'); ?></h6>
                                    <a href="mailto:<?php echo e($ps->email); ?>" class="text--base"><?php echo e($ps->email); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="mt-5">
                <div class="contact-wrapper bg--body border rounded">
                    <div class="section-header">
                        <h3 class="section-header__subtitle mb-0"><?php echo app('translator')->get('Send Message to Get Connected'); ?></h3>
                    </div>
                    <form class="row g-4" action="<?php echo e(route('front.contact.submit')); ?>" id="contactform">
                        <?php echo csrf_field(); ?>
                        <div class="col-sm-6 form-group">
                            <label for="name" class="form-label"><?php echo app('translator')->get('Your Name'); ?></label>
                            <input type="text" name="name" class="form-control bg--section" id="name">
                        </div>

                        <div class="col-sm-6 form-group">
                            <label for="email" class="form-label"><?php echo app('translator')->get('Your Email'); ?></label>
                            <input type="email" name="email" class="form-control bg--section" id="email">
                        </div>

                        <div class="col-sm-6 form-group">
                            <label for="phone" class="form-label"><?php echo app('translator')->get('Your Phone'); ?></label>
                            <input type="text" name="phone" class="form-control bg--section" id="phone">
                        </div>

                        <div class="col-sm-6 form-group">
                            <label for="subject" class="form-label"><?php echo app('translator')->get('Your Subject'); ?></label>
                            <select name="subject" id="subject" class="form-control bg--section">
                                <option value="Investment"><?php echo app('translator')->get('Investment'); ?></option>
                                <option value="Withdraw"><?php echo app('translator')->get('Withdraw'); ?></option>
                                <option value="Transaction"><?php echo app('translator')->get('Transaction'); ?></option>
                                <option value="Deposit"><?php echo app('translator')->get('Deposit'); ?></option>
                            </select>
                        </div>

                        <div class="col-sm-12 form-group">
                            <label for="phone" class="form-label"><?php echo app('translator')->get('Your Message'); ?></label>
                            <textarea name="message" id="message" class="form-control bg--section"></textarea>
                        </div>

                        <div class="col-sm-12">
                            <button class="cmn--btn w-100" type="submit"><?php echo app('translator')->get('Send Message'); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
    <!-- Contact Section -->

    <!-- Payment Gateways -->
    <?php if ($__env->exists('partials.front.payment')) echo $__env->make('partials.front.payment', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Payment Gateways -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\mamp\htdocs\geniushyip\project\resources\views/frontend/contact.blade.php ENDPATH**/ ?>